<?php

class PageBase {

	private static $shared_instances = [];

	/**
	 * @return static
	 */
	protected static function get_shared() {
		$class = static::class;
		if ( ! isset( self::$shared_instances[ $class ] ) ) {
			self::$shared_instances[ $class ] = new $class;
		}
		return self::$shared_instances[ $class ];
	}
}