<?php

class WsIdField {
	const KEY = "ws_id";


	static function show( $post ) {
		$ws_id = get_post_meta( $post->ID, self::KEY, true );
		?>
		<h3>WS ID</h3>
		<input type="text" placeholder="ID" name="<?php echo self::KEY ?>"
		       value="<?php echo $ws_id ?>"
		>
		<?php
	}

	static function save_ws_id( $post_id ) {
		if ( isset( $_POST[ self::KEY ] ) ) {
			update_post_meta( $post_id, self::KEY, sanitize_text_field( $_POST[ self::KEY ] ) );
		}
	}
}

add_action( 'save_post', [ WsIdField::class, 'save_ws_id' ] );