<?php

class TitleField {
	const KEY = "title";

	static function show( $post ) {
		$title_value = get_post_meta( $post->ID, self::KEY, true );
		?>
		<h3>Title</h3>
		<input type="text" placeholder="Title" name="<?php echo self::KEY ?>"
		       value="<?php echo $title_value ?>"
		>
		<?php
	}

	static function save_title( $post_id ) {
		if ( isset( $_POST[ self::KEY ] ) ) {
			update_post_meta( $post_id, self::KEY, sanitize_text_field( $_POST[ self::KEY ] ) );
		}
	}
}

add_action( 'save_post', [ TitleField::class, 'save_title' ] );