<?php

class DescriptionField {
	const KEY = "description";

	static function show( $post ) {
		$description_value = get_post_meta( $post->ID, self::KEY, true );
		?>
		<h3>Description</h3>
		<textarea class="textarea-metabox" name="<?php echo self::KEY ?>" placeholder="Description">
            <?php echo esc_textarea($description_value) ?>
        </textarea>
		<?php
	}

	static function save_description( $post_id ) {
		if ( isset( $_POST[ self::KEY ] ) ) {
			update_post_meta( $post_id, self::KEY, sanitize_text_field( $_POST[ self::KEY ] ) );
		}
	}
}
add_action( 'save_post', [ DescriptionField::class, 'save_description' ] );