<?php

class Notice {
	private string $message;
	private string $type;
    private bool $is_temporary;


    public function __construct($message, $type, $is_temporary) {
        $this->message = $message;
        $this->type = $type;
        $this->is_temporary = $is_temporary;
    }

    function show() {
	    add_action("admin_notices", [$this, "display_notice_content"]);
    }

	function display_notice_content() {
		?>
        <div id="token-missing-notice" class="notice notice-<?php echo $this->type?>">
            <p><?php echo $this->message?></p>
        </div>
		<?php if ($this->is_temporary): ?>
            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    setTimeout(function() {
                        $('#token-missing-notice').fadeOut('fast');
                    }, 6000);
                });
            </script>
		<?php endif; ?>
		<?php
	}
}
