<?php

class Ai2MediaService {
	static function get_data()
	{
		$url = "https://ai2media.ru/api/datas";
		$headers = [
			"token: " . get_option( SettingsPage::TOKEN_OPTION_NAME ),
			"ws: " . get_option( SettingsPage::WS_OPTION_NAME )
		];
		$response = Ai2MediaService::requestH( $url, $headers );
		if ( ! $response ) {
			return null;
		} else {
			return $response->data;
		}
	}

    static function get_image($promt) {
        $url = "https://ai2media.ru/genim";
        $args = array(
            'headers' => array(
                'token' => get_option(SettingsPage::TOKEN_OPTION_NAME),
                'promt' => $promt
            ),
            'timeout' => 30
        );

        $response = wp_remote_get($url, $args);

        if (is_wp_error($response)) {
            error_log($response->get_error_message());
            return null;
        } else {
            $image_url = wp_remote_retrieve_body($response);
            return $image_url;
        }
    }

	static function rewrite_text($raw_text) {
        $url = "https://ai2media.ru/rewr";
        $args = array(
            'headers' => array(
                'token' => get_option(SettingsPage::TOKEN_OPTION_NAME),
                'text' => $raw_text
            ),
            'timeout' => 30
        );

        $response = wp_remote_get($url, $args);

        if (is_wp_error($response)) {
            error_log($response->get_error_message());
            return null;
        } else {
            return wp_remote_retrieve_body($response);
        }
    }



	static function get_workspaces($token) {
		$url      = "https://ai2media.ru/api/ws";
		$args = array(
			'headers' => array(
				"token" => $token
			),
			'timeout' => 30
		);
		$response = wp_remote_get($url, $args);

		if (is_wp_error($response)) {
			error_log($response->get_error_message());
			return null;
		} else {
			$body = wp_remote_retrieve_body($response);
			return json_decode($body, true);
		}
	}

    static function update_data() {
        $url      = "https://ai2media.ru/api/datas-update";
        $headers  = [
            "token: " . get_option( SettingsPage::TOKEN_OPTION_NAME ),
            "ws: " . get_option( SettingsPage::WS_OPTION_NAME )
        ];
        self::requestH( $url, $headers );
    }

	static function ws_ai2media() {
		$url      = "https://ai2media.ru/api/ws";
		$headers  = [
			"token: 2bd58a1q900012df19b01312",
		];
		$response = self::requestH( $url, $headers );
		print_r( $response );
	}

	static function get_data_ai2media() {
		$url      = "https://ai2media.ru/api/datas";
		$headers  = [
			"token: 2bd58a1q900012df19b01312",
			"ws: 64e3346df8004ef5c4e22417"
		];
		$response = self::requestH( $url, $headers );
		// $post_id = post_exists('Your title');
		if ( ! $response ) {
			return false;
		}
// echo "<pre>";
// 	print_r(count ($response->data));
// 	echo "</pre>";
		foreach ( $response->data as $key => $obj ) {
			foreach ( $obj->data->d as $key => $data ) {

				$post_id = post_exists( $data->title );
				if ( $post_id ) {
					continue;
				}

				$post_data = array(
					'post_title'   => sanitize_text_field( $data->title ),
					'post_content' => $data->summary,
					'post_status'  => 'draft',
					'post_type'    => 'post',
				);
				$post_id   = wp_insert_post( $post_data );

				// echo "<pre>";
				// print_r($data);
				// echo "</pre>";
				// var_dump($post_id);
			}

		}
		exit;
		// echo "<pre>";
		// print_r($response);
	}

	static function update_data_ai2media() {
		$url      = "https://ai2media.ru/api/datas-update";
		$headers  = [
			"token: 2bd58a1q900012df19b01312",
			"ws: 64e3346df8004ef5c4e22417"
		];
		$response = self::requestH( $url, $headers );
		echo "<pre>";
		print_r( $response );
		echo "</pre>";
		exit;
	}

	static function requestH( $url, $headers = [] ) {
		$curl = curl_init();
		curl_setopt_array( $curl, array(
			CURLOPT_URL            => $url,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_ENCODING       => "",
			CURLOPT_MAXREDIRS      => 10,
			CURLOPT_TIMEOUT        => 30,
			CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST  => "GET",
			CURLOPT_HTTPHEADER     => $headers,
		) );
		$response = curl_exec( $curl );
		$err      = curl_error( $curl );
		curl_close( $curl );
		if ( $err ) {
			//Only show errors while testing
			//echo "cURL Error #:" . $err;
			return false;
		} else {
			//The API returns data in JSON format, so first convert that to an array of data objects
			$responseObj = json_decode( $response );

			return $responseObj;
		}
	}
}
