<?php
// add_action('init', function() {
// 	// global $wpdb;
// 	// $user_id = get_current_user_id();
// 	// $result = $wpdb->get_results( "SELECT `post_id` FROM `wp_postmeta` WHERE `meta_value` = '{$user_id}' AND `meta_key` = 'cr_seller_id'" );
// 	// $post_id = current($result)->post_id;

//     $url_path = trim(parse_url(add_query_arg(array()), PHP_URL_PATH), '/');
//     if ( $url_path === 'a2media_get' ) {
//     	get_data_ai2media();
// 		// include  'views/sale_orders.php';
// 		exit();
//     }else ($url_path === 'a2media_get_2'){

// 		exit();
// 	}
// });



require 'data/Ai2MediaDataTable.php';
require 'data/Ai2MediaDataHandler.php';
require 'includes/Ai2MediaService.php';
require "pages/PageBase.php";
require "pages/TablePage.php";
require "pages/SettingsPage.php";
require "includes/Notice.php";
require "meta-boxes/AiImageField.php";
require "meta-boxes/WsIdField.php";
require "meta-boxes/TitleField.php";
require "meta-boxes/DescriptionField.php";
require "meta-boxes/RewriteBtn.php";
require "meta-boxes/Ai2MediaMetaBox.php";

////  Initialisation  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
add_action('admin_menu', 'admin_menu', 10);

function admin_menu() {
    add_menu_page('Ai2media', 'Ai2media', 'manage_options', 'ai2media',
        [TablePage::get_shared(), 'show'], 'dashicons-database-import', 1);
    add_submenu_page("ai2media", __("Settings", "a2m"), __("Settings", "a2m"),
        'manage_options', SettingsPage::PAGE_NAME, [SettingsPage::get_shared(), 'show']);

	add_action('admin_init', [TablePage::get_shared(), 'buttons_handler' ] );
	add_action('admin_init', [SettingsPage::get_shared(), "ai2media_settings_init"] );
	add_action('admin_init', "add_custom_meta_boxes");

    add_action('admin_enqueue_scripts', 'load_js_scripts_and_css_styles');
}

////  Enable scripts  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function load_js_scripts_and_css_styles() {
	load_scripts_for_ai2media_page();
	load_scripts_for_settings_page();
	load_scripts_for_metaboxes();

	wp_enqueue_script('helpers-js', plugins_url('js/helpers.js', __FILE__), array('jquery'), "1.1.0", true);
	wp_enqueue_style('css-styles', plugins_url('css/style.css', __FILE__), array(), '1.1.0', 'all');
}

function load_scripts_for_ai2media_page() {
	$translation_array = array(
		'createPost' => __('Are you sure you want to create posts from %d records?', 'a2m'),
		'removeRecord' => __('Are you sure you want to delete %d records?', 'a2m'),
		'clearTable' => __('Are you sure you want to clear the ENTIRE table?', 'a2m'),
		'selectRecord' => __('Please select at least one record.', 'a2m')
	);

	if (check_page_is_current(TablePage::PAGE_NAME)) {
		wp_register_script('main_scripts', plugins_url('js/ai2media.js', __FILE__),  array('jquery'), "1.0.0", true);
		wp_localize_script('main_scripts', 'Message', $translation_array);
		wp_enqueue_script('main_scripts');
	}
}

function load_scripts_for_settings_page() {
	$data = array(
		"saved_ws_id" => get_option( SettingsPage::WS_OPTION_NAME )
	);

	if (check_page_is_current(SettingsPage::PAGE_NAME)) {
		wp_register_script('settings_scripts', plugins_url('js/settings.js', __FILE__),  array('jquery'), "1.0.0", true);
		wp_localize_script('settings_scripts', 'Data', $data);
		wp_enqueue_script('settings_scripts');
	}
}

function load_scripts_for_metaboxes() {
	$is_edit_post_screen = get_current_screen()->base == "post";
	if ($is_edit_post_screen) {
		wp_enqueue_script('meta-box-scripts', plugins_url('js/meta-box-scripts.js', __FILE__), array('jquery'), "2.0.0", true);
	}
}

function check_page_is_current($current_page_name) {
	$current_screen = get_current_screen()->id;
	$current_screen = str_replace("toplevel_page_", "", $current_screen);
	$current_screen = str_replace("ai2media_page_", "", $current_screen);

	if ($current_page_name == $current_screen) {
		return true;
	} else {
		return false;
	}
}

////  Meta boxes  /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
function add_custom_meta_boxes() {
	Ai2MediaMetaBox::add_to_post_editor();
}
