<?php
/**
 * Plugin Name: Ai2media manager
 * Description: Importing and managing content from A2media
 * Plugin URI:  https://ai2media.ru/
 * Author URI:  https://ai2media.ru/
 * Author:      Ai2media
 * Text Domain: a2m
 * Version:     1.0
 *

 *
 * License:     GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * Network:     false
 */

load_plugin_textdomain("a2m", false, basename(dirname(__FILE__)) . '/languages/');
if ( ! class_exists( 'Ai2media_Manager' ) ) {

    /**
     * Cart Tab class
     */
    class Ai2media_Manager {

        /**
         * The token.
         *
         * @var     string
         * @access  public
         * @since   1
         */
        public $token;

        /**
         * The version number.
         *
         * @var     string
         * @access  public
         * @since   1
         */
        public $version;

        /**
         * Set up all the things
         */
        public function __construct() {
            $this->token   = 'a2media-manager';
            $this->version = '1';
            $this->setup();
            register_activation_hook( __FILE__, array( $this, 'install') );
            register_deactivation_hook( __FILE__, array( $this, 'tearDown') );
        }

        /**
         * Installation.
         * Runs on activation. Logs the version number.
         *
         * @access  public
         * @since   1.1.1
         * @return  void
         */
        public function install() {
            update_option( $this->token . '-version', $this->version );
            Ai2MediaDataHandler::create_db();
        }

        /**
         * Setup
         *
         * @return void
         */
        public function setup() {
            require_once( plugin_dir_path( __FILE__ ) . '/import.php' );
        }

        public function tearDown()
        {
            // дествие при деактивации
        }

    }

    $ai2media_manager = new Ai2media_Manager();
    register_uninstall_hook(__FILE__, "delete_db");
    function delete_db()
    {
        Ai2MediaDataHandler::delete_db();
    }
}


